function [wie wije]=eff2lnofe(wieff, wijeff, th, lam, phig)
% ------------------------------------------------------------------------|
% DESCRIPTION
% - rotates acceleration vector and Eotvos tensor from Earth Fixed Frame
%   to Local North Oriented Frame: EFF->LNOFe
% use:
% [wie wije]=eff2lnofe(wieff, wijeff, phi,lam, phig)
% ------------------------------------------------------------------------|
% INPUT:
% wieff - acceleration vector, [whatever] ... mGal or m/s^2, matrix(:,:,3)
% wijeff - Eotvos tensor, [whatever]      ... E or 1/s^2, matrix(:,:,6)
%        - wijeff(:,:,1) = Wxx
%        - wijeff(:,:,2) = Wxy
%        - wijeff(:,:,3) = Wxz
%        - wijeff(:,:,4) = Wyy
%        - wijeff(:,:,5) = Wyz
%        - wijeff(:,:,6) = Wzz
% th - matrix(:,:) with polar angle = 90-geocentric latitude, [rad]
% lam-  matrix(:,:) with longitude, [rad]
% phig - matrix(:,:) with geodetic/ellipsoidal latitude, [rad]
% ------------------------------------------------------------------------|
% OUTPUT:
% wie - acceleration vector in LNOFe
%     - wie(:,:,1) = Wx
%     - wie(:,:,2) = Wy
%     - wie(:,:,3) = Wz
% wije - Eotvos tensor in LNOFe
%      - wije(:,:,1) = Wxx
%      - wije(:,:,2) = Wxy
%      - wije(:,:,3) = Wxz
%      - wije(:,:,4) = Wyy
%      - wije(:,:,5) = Wyz
%      - wije(:,:,6) = Wzz
% ------------------------------------------------------------------------|
% OTHERS:
% JS(12-2011)
% ------------------------------------------------------------------------|
% REFERENCES
% ------------------------------------------------------------------------|
[s1 s2 s3a]=size(wieff);
[s1 s2 s3b]=size(wijeff);

wie=zeros(s1,s2,s3a);
wije=zeros(s1,s2,s3b);

Rlam=zeros(3,3,s2);
for j=1:s2
    Rlam(:,:,j)=rz((lam(1,j)-pi));
end

for i=1:s1
   R1a=ry(-th(i,1));
   
   % LNOFs -> LNOFe
   alpha=(phig(i,1)-(pi/2-th(i,1)));
   R2=ry(alpha);
       
   for j=1:s2           
       
       % EFF -> LNOFs
%        [size(R1a) size(Rlam)]
       Rtemp=Rlam(:,:,j);
       R1=R1a*Rtemp; % right handed system, 
       
       % EFF -> LNOFe
       R=R2*R1;
       
       wieff0  = [wieff(i,j,1); wieff(i,j,2); wieff(i,j,3)];
       wijeff0 = [wijeff(i,j,1) wijeff(i,j,2) wijeff(i,j,3); wijeff(i,j,2) wijeff(i,j,4)...
                  wijeff(i,j,5); wijeff(i,j,3) wijeff(i,j,5) wijeff(i,j,6)];

       % rotation into LNOFe
       wilnofe  = R*wieff0;
       wijlnofe = R*wijeff0*R';

       wie(i,j,1) = wilnofe(1);
       wie(i,j,2) = wilnofe(2);
       wie(i,j,3) = wilnofe(3);
       
       wije(i,j,1) = wijlnofe(1,1);
       wije(i,j,2) = wijlnofe(1,2);
       wije(i,j,3) = wijlnofe(1,3);
       wije(i,j,4) = wijlnofe(2,2);
       wije(i,j,5) = wijlnofe(2,3);
       wije(i,j,6) = wijlnofe(3,3);
       
   end    
end